#define LNK_VERBOSE 0 


typedef long dword ; 
typedef dword qword[ 2 ] ; 


#define GUID_LENGTH 16 



typedef unsigned char GUID[ GUID_LENGTH ] ; 


struct lnk_header { 
	dword indicator ; 
	GUID guid ; 
	dword flags ; 
	dword file_attr ; 
	qword time1 ; 
	qword time2 ; 
	qword time3 ; 
	dword file_length ; 
	dword icon_number ; 
	dword showWnd ; 
	dword hot_key ; 
	dword unknown1 ; 
	dword unknown2 ; 
} ; 


struct file_location_info { 
	dword total_length ; 
	dword first_following_offset ; 
	dword flags ; 
	dword local_volume_info_offset ; 
	dword base_pathname_offset ; 
	dword network_volume_info_offset ; 
	dword remaining_pathname_offset ; 
} ; 


struct lnk_header_and_next_length { 
	struct lnk_header header ; 
	unsigned short next_length ; 
} ; 


#define lnk_header_indicator 0x4C 


GUID lnk_GUID_1 = { 
	0x01, 0x14, 0x02, 0x00, 
		0x00, 0x00, 0x00, 0x00, 
		0xC0, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x46 
} ; 


/* The flags */
#define HAS_SHELL_ITEM_LIST 0x01 
#define POINTS_TO_FILE 0x02 
#define HAS_DESCRIPTION_STRING 0x04 
#define HAS_RELATIVE_PATH 0x08 
#define HAS_WORKING_DIRECTORY 0x10 
#define HAS_COMMAND_LINE_ARGS 0x20 
#define HAS_CUSTOM_ICON 0x40 


#ifdef LNK_VERBOSE 
static /*const*/ char* flag_message[ 7][ 2 ] = { 
	{ "The shell item id list is absent", "The shell item id list is 	present" }, 
	{ "Points to something else", "Points to a file or directory" }, 
	{ "No description string", "Has a description string" }, 
	{ "No relative path", "Has a relative path string" }, 
	{ "No working directory", "Has a working directory" }, 
	{ "No command line arguments", "Has command line arguments" }, 
	{ "Has the default icon", "Has a custom icon" }, 
} ; 
#endif // LNK_VERBOSE 


#define TARGET_READ_ONLY 0x01 
#define TARGET_HIDDEN 0x02 
#define TARGET_SYSTEM 0x04 
#define TARGET_VOLUME_LABEL 0x08 
#define TARGET_DIRECTORY 0x10 
#define TARGET_ARCHIVE 0x20 
#define TARGET_ENCRYPTED 0x40 
#define TARGET_NORMAL 0x80 
#define TARGET_TEMPORARY 0x100 
#define TARGET_SPARSE 0x200 
#define TARGET_REPARSE 0x400 
#define TARGET_COMPRESSED 0x800 
#define TARGET_OFFLINE 0x1000 


#define VOLUME_LOCAL 0x1 
#define VOLUME_NETWORK 0x2 
#define VOLUME_LOCAL_NETWORK 0x3


#ifdef LNK_VERBOSE 
static /*const*/ char* target_message[] = { 
	"Target is read only.", 
		"Target is hidden.", 
		"Target is a system file.", 
		"Target is a volume label. (Not possible)", 
		"Target is a directory.", 
		"Target has been modified since last backup. (archive)", 
		"Target is encrypted (NTFS EFS)", 
		"Target is Normal??", 
		"Target is temporary.", 
		"Target is a sparse file.", 
		"Target has reparse point data.", 
		"Target is compressed.", 
		"Target is offline." 
} ; 
#endif //LNK_VERBOSE 


#define LNK_OK_RELATIVE_PATH 2 
#define LNK_OK_ABSOLUTE_PATH 1 
#define LNK_OK_NOT_A_FILE_OR_DIRECTORY 0 
#define LNK_NOT_A_LNK_FILE -1 
#define LNK_BAD_GUID -2
#define LNK_PATH_BUFFER_TOO_SHORT -3 
#define LNK_SEEK_ERROR -4 
#define LNK_READ_ERROR -5 




#ifdef LNK_VERBOSE 
#define LNK_ERROR_ADJUST 4 
char* lnk_err_message[] = { 
	"LNK_READ_ERROR", 
		"LNK_SEEK_ERROR", 
		"LNK_PATH_BUFFER_TOO_SHORT", 
		"LNK_BAD_GUID", 
		"LNK_NOT_A_LNK_FILE", 
		"LNK_OK_NOT_A_FILE_OR_DIRECTORY", 
		"LNK_OK_ABSOLUTE_PATH", 
		"LNK_OK_RELATIVE_PATH" 
} ; 
#endif
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>

#define DEBUG 1